-- Database Schema for Halo Pemko Kota Langsa
-- Pengaduan Masyarakat Berbasis Tiket

CREATE DATABASE IF NOT EXISTS halopemko CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE halopemko;

-- Table: users
-- Menyimpan data pengguna (Admin, Operator, PIC)
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    name VARCHAR(100) NOT NULL,
    role ENUM('admin', 'operator', 'pic') NOT NULL,
    email VARCHAR(100),
    phone VARCHAR(20),
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: operator_shifts
-- Menyimpan jadwal shift operator aktif
CREATE TABLE operator_shifts (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    shift_date DATE NOT NULL,
    shift_start TIME NOT NULL,
    shift_end TIME NOT NULL,
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_shift_date (shift_date),
    INDEX idx_user_shift (user_id, shift_date)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tickets
-- Menyimpan data pengaduan/tiket
CREATE TABLE tickets (
    id INT AUTO_INCREMENT PRIMARY KEY,
    ticket_no VARCHAR(20) UNIQUE NOT NULL,
    reporter_name VARCHAR(100) NOT NULL,
    reporter_phone VARCHAR(20) NOT NULL,
    reporter_email VARCHAR(100),
    reporter_address TEXT,
    subject VARCHAR(255) NOT NULL,
    description TEXT NOT NULL,
    category VARCHAR(50),
    priority ENUM('low', 'medium', 'high', 'urgent') DEFAULT 'medium',
    attachment_path VARCHAR(255),
    attachment_type VARCHAR(50),
    status ENUM('pending', 'assigned', 'forwarded', 'in_progress', 'resolved', 'rejected') DEFAULT 'pending',
    assigned_to INT NULL,
    assigned_at TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    resolved_at TIMESTAMP NULL,
    FOREIGN KEY (assigned_to) REFERENCES users(id) ON DELETE SET NULL,
    INDEX idx_ticket_no (ticket_no),
    INDEX idx_status (status),
    INDEX idx_assigned_to (assigned_to),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: ticket_comments
-- Menyimpan komentar dan bukti dari PIC
CREATE TABLE ticket_comments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    ticket_id INT NOT NULL,
    user_id INT NOT NULL,
    comment TEXT NOT NULL,
    attachment_path VARCHAR(255),
    attachment_type VARCHAR(50),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (ticket_id) REFERENCES tickets(id) ON DELETE CASCADE,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_ticket_id (ticket_id),
    INDEX idx_user_id (user_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default admin user
-- Password: admin123 (hash: password_hash('admin123', PASSWORD_DEFAULT))
INSERT INTO users (username, password, name, role, email) VALUES
('admin', '$2y$10$IrpXRFxXWTWaarQzRrDYNOg22Evt70cqn1f5jMLP3M2GQiZ6QnQPC', 'Administrator', 'admin', 'admin@halopemko.langsa.go.id');

-- Insert sample operator
INSERT INTO users (username, password, name, role, email) VALUES
('operator1', '$2y$10$IrpXRFxXWTWaarQzRrDYNOg22Evt70cqn1f5jMLP3M2GQiZ6QnQPC', 'Operator Satu', 'operator', 'operator1@halopemko.langsa.go.id');

-- Insert sample PIC
INSERT INTO users (username, password, name, role, email) VALUES
('pic1', '$2y$10$IrpXRFxXWTWaarQzRrDYNOg22Evt70cqn1f5jMLP3M2GQiZ6QnQPC', 'PIC Satu', 'pic', 'pic1@halopemko.langsa.go.id');

