<?php
/**
 * Entry Point - Halo Pemko Kota Langsa
 * Simple Routing System
 */

// Set timezone to Asia/Jakarta
date_default_timezone_set('Asia/Jakarta');

// Start session
session_start();

// Define base path
define('BASE_PATH', dirname(__DIR__));

// Load helpers
require_once BASE_PATH . '/app/helpers/Database.php';
require_once BASE_PATH . '/app/helpers/Auth.php';
require_once BASE_PATH . '/app/helpers/Middleware.php';

// Load models
require_once BASE_PATH . '/app/models/User.php';
require_once BASE_PATH . '/app/models/Ticket.php';
require_once BASE_PATH . '/app/models/OperatorShift.php';
require_once BASE_PATH . '/app/models/TicketComment.php';
require_once BASE_PATH . '/app/models/Category.php';
require_once BASE_PATH . '/app/models/OperatorLoginToken.php';

// Load controllers
require_once BASE_PATH . '/app/controllers/HomeController.php';
require_once BASE_PATH . '/app/controllers/ReportController.php';
require_once BASE_PATH . '/app/controllers/StatusController.php';
require_once BASE_PATH . '/app/controllers/AuthController.php';
require_once BASE_PATH . '/app/controllers/DashboardController.php';
require_once BASE_PATH . '/app/controllers/TicketController.php';
require_once BASE_PATH . '/app/controllers/OperatorController.php';
require_once BASE_PATH . '/app/controllers/PICController.php';
require_once BASE_PATH . '/app/controllers/SettingsController.php';
require_once BASE_PATH . '/app/controllers/CategoryController.php';

// Get action from query string
$action = $_GET['action'] ?? 'home';

// Route handling
switch ($action) {
    // Public pages
    case 'home':
        $controller = new HomeController();
        $controller->index();
        break;

    case 'report':
        $controller = new ReportController();
        $controller->showForm();
        break;

    case 'report_submit':
        $controller = new ReportController();
        $controller->submit();
        break;

    case 'status':
        $controller = new StatusController();
        $controller->showForm();
        break;

    // Authentication
    case 'login':
        $controller = new AuthController();
        $controller->showLogin();
        break;

    case 'login_submit':
        $controller = new AuthController();
        $controller->login();
        break;

    case 'logout':
        $controller = new AuthController();
        $controller->logout();
        break;

    case 'operator_auto_login':
        $controller = new AuthController();
        $controller->operatorAutoLogin();
        break;

    // Dashboard
    case 'dashboard':
        $controller = new DashboardController();
        $controller->index();
        break;

    // Ticket management
    case 'ticket':
        $controller = new TicketController();
        $id = $_GET['id'] ?? null;
        if ($id) {
            $controller->show($id);
        } else {
            header('Location: /halopemko/public/index.php?action=dashboard');
            exit;
        }
        break;

    case 'ticket_assign':
        $controller = new TicketController();
        $controller->assign();
        break;

    case 'ticket_forward_pic':
        $controller = new TicketController();
        $controller->forwardToPIC();
        break;

    case 'ticket_start_work':
        $controller = new TicketController();
        $controller->startWork();
        break;

    case 'ticket_complete':
        $controller = new TicketController();
        $controller->complete();
        break;

    case 'ticket_complete_admin':
        $controller = new TicketController();
        $controller->completeByAdmin();
        break;

    case 'ticket_complete_operator':
        $controller = new TicketController();
        $controller->completeByOperator();
        break;

    case 'ticket_update_status':
        $controller = new TicketController();
        $controller->updateStatus();
        break;

    case 'ticket_add_comment':
        $controller = new TicketController();
        $controller->addComment();
        break;

    case 'wa_start_work':
        $controller = new TicketController();
        $controller->whatsappStartWork();
        break;

    case 'wa_progress':
        $controller = new TicketController();
        $controller->whatsappProgress();
        break;

    case 'wa_submit_progress':
        $controller = new TicketController();
        $controller->whatsappSubmitProgress();
        break;

    case 'wa_submit_complete':
        $controller = new TicketController();
        $controller->whatsappSubmitCompletion();
        break;

    // Operator management
    case 'operators':
        $controller = new OperatorController();
        $controller->index();
        break;

    case 'operator_create':
        $controller = new OperatorController();
        $controller->create();
        break;

    case 'operator_store':
        $controller = new OperatorController();
        $controller->store();
        break;

    case 'operator_edit':
        $controller = new OperatorController();
        $controller->edit();
        break;

    case 'operator_update':
        $controller = new OperatorController();
        $controller->update();
        break;

    case 'operator_delete':
        $controller = new OperatorController();
        $controller->delete();
        break;

    case 'operator_shifts':
        $controller = new OperatorController();
        $controller->manageShifts();
        break;

    case 'operator_shift_store':
        $controller = new OperatorController();
        $controller->storeShift();
        break;

    case 'operator_shift_update':
        $controller = new OperatorController();
        $controller->updateShift();
        break;

    case 'operator_shift_delete':
        $controller = new OperatorController();
        $controller->deleteShift();
        break;

    // PIC management
    case 'pics':
        $controller = new PICController();
        $controller->index();
        break;

    case 'pic_create':
        $controller = new PICController();
        $controller->create();
        break;

    case 'pic_store':
        $controller = new PICController();
        $controller->store();
        break;

    case 'pic_edit':
        $controller = new PICController();
        $controller->edit();
        break;

    case 'pic_update':
        $controller = new PICController();
        $controller->update();
        break;

    case 'pic_delete':
        $controller = new PICController();
        $controller->delete();
        break;

    case 'pic_destroy':
        $controller = new PICController();
        $controller->destroy();
        break;

    // Settings management (admin only)
    case 'settings':
        $controller = new SettingsController();
        $controller->index();
        break;

    case 'settings_update':
        $controller = new SettingsController();
        $controller->update();
        break;

    case 'settings_change_password':
        $controller = new SettingsController();
        $controller->changePassword();
        break;

    // Category management (admin only)
    case 'categories':
        $controller = new CategoryController();
        $controller->index();
        break;

    case 'category_create':
        $controller = new CategoryController();
        $controller->create();
        break;

    case 'category_store':
        $controller = new CategoryController();
        $controller->store();
        break;

    case 'category_edit':
        $controller = new CategoryController();
        $controller->edit();
        break;

    case 'category_update':
        $controller = new CategoryController();
        $controller->update();
        break;

    case 'category_delete':
        $controller = new CategoryController();
        $controller->delete();
        break;

    case 'category_toggle':
        $controller = new CategoryController();
        $controller->toggleActive();
        break;

    default:
        header('Location: /halopemko/public/index.php?action=home');
        exit;
}

