<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title ?? 'Informasi Pengaduan'); ?></title>
    <link rel="stylesheet" href="/halopemko/public/assets/css/style.css">
    <style>
        body.wa-page {
            min-height: 100vh;
            background: #f4f6fb;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Inter', sans-serif;
            padding: 24px;
        }
        .wa-card {
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 20px 60px rgba(15, 41, 77, 0.08);
            max-width: 480px;
            width: 100%;
            padding: 32px;
            text-align: center;
        }
        .wa-card h1 {
            font-size: 1.5rem;
            margin-bottom: 16px;
            color: #1b3a57;
        }
        .wa-card p {
            color: #4f5d75;
            line-height: 1.6;
            margin-bottom: 24px;
        }
        .wa-card a.btn-primary,
        .wa-card a.btn-secondary {
            display: inline-block;
            padding: 12px 24px;
            border-radius: 999px;
            text-decoration: none;
            font-weight: 600;
            transition: background 0.2s ease;
        }
        .wa-card a.btn-primary {
            background: #2563eb;
            color: #fff;
        }
        .wa-card a.btn-secondary {
            background: #25d366;
            color: #fff;
        }
        .wa-card a.btn-secondary:hover {
            background: #1ebe5c;
        }
        .wa-card .button-group {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 8px;
            margin-bottom: 4px;
        }
        .wa-card a.btn-primary:hover {
            background: #1d4ed8;
        }
        .wa-card small {
            display: block;
            color: #94a3b8;
            margin-top: 18px;
        }
    </style>
</head>
<body class="wa-page">
    <div class="wa-card">
        <h1><?= htmlspecialchars($title ?? 'Informasi Pengaduan'); ?></h1>
        <p><?= nl2br(htmlspecialchars($message ?? '')); ?></p>
        <?php if ((!empty($buttonLabel) && !empty($buttonUrl)) || (!empty($secondaryButtonLabel) && !empty($secondaryButtonUrl))): ?>
            <div class="button-group">
                <?php if (!empty($buttonLabel) && !empty($buttonUrl)): ?>
                    <a href="<?= htmlspecialchars($buttonUrl); ?>" class="btn-primary"><?= htmlspecialchars($buttonLabel); ?></a>
                <?php endif; ?>
                <?php if (!empty($secondaryButtonLabel) && !empty($secondaryButtonUrl)): ?>
                    <a href="<?= htmlspecialchars($secondaryButtonUrl); ?>" class="btn-secondary" target="_blank" rel="noopener"<?= !empty($secondaryButtonAppUrl) ? ' data-app-url="' . htmlspecialchars($secondaryButtonAppUrl) . '"' : ''; ?>><?= htmlspecialchars($secondaryButtonLabel); ?></a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <small>Halo Pemko Kota Langsa</small>
    </div>
    <script>
    (function() {
        var buttons = document.querySelectorAll('.btn-secondary[data-app-url]');
        if (!buttons.length) {
            return;
        }

        buttons.forEach(function(button) {
            button.addEventListener('click', function(event) {
                var appUrl = button.getAttribute('data-app-url');
                if (!appUrl) {
                    return;
                }

                event.preventDefault();
                var fallbackUrl = button.getAttribute('href');
                var isHandled = false;
                var clearHandlers = function() {
                    if (isHandled) {
                        return;
                    }
                    isHandled = true;
                    clearTimeout(timeoutId);
                    document.removeEventListener('visibilitychange', visibilityHandler);
                };
                var visibilityHandler = function() {
                    if (document.hidden) {
                        clearHandlers();
                    }
                };
                var timeoutId = setTimeout(function() {
                    if (!isHandled && fallbackUrl) {
                        window.location.href = fallbackUrl;
                    }
                }, 1200);

                document.addEventListener('visibilitychange', visibilityHandler);
                window.addEventListener('pagehide', clearHandlers, { once: true });

                window.location.href = appUrl;
            });
        });
    })();
</script>
</body>
</html>

