<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cek Status Pengaduan - Halo Pemko Kota Langsa</title>
    <link rel="stylesheet" href="/halopemko/public/assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        /* Android Material Design Status Page Styles */
        * {
            font-family: 'Roboto', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
        }

        body {
            background: linear-gradient(135deg, #E3F2FD 0%, #BBDEFB 50%, #90CAF9 100%);
            min-height: 100vh;
            padding: 0;
            margin: 0;
        }

        /* Android App Bar */
        .app-bar {
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 50%, #42A5F5 100%);
            color: white;
            padding: 16px 0;
            box-shadow: 0 2px 4px rgba(0,0,0,0.2);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .app-bar-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 16px;
        }

        .app-title {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
        }

        .app-icon {
            color: white;
        }

        .app-title h1 {
            font-size: 20px;
            font-weight: 500;
            margin: 0;
            color: white;
            text-align: center;
        }

        /* Android Navigation Menu */
        .nav-menu-container {
            background: linear-gradient(135deg, #FFFFFF 0%, #F0F7FF 100%);
            padding: 16px;
            box-shadow: 0 2px 4px rgba(33, 150, 243, 0.1);
            margin-bottom: 16px;
            border-bottom: 1px solid rgba(33, 150, 243, 0.1);
        }

        .nav-menu-grid {
            max-width: 900px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 12px;
        }

        .nav-menu-item {
            background: #f5f5f5;
            border-radius: 16px;
            padding: 20px 16px;
            text-decoration: none;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 12px;
            transition: all 0.2s cubic-bezier(0.4, 0.0, 0.2, 1);
            cursor: pointer;
            border: 2px solid transparent;
            position: relative;
            overflow: hidden;
            -webkit-tap-highlight-color: transparent;
            touch-action: manipulation;
        }

        .nav-menu-item::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(33, 150, 243, 0.1);
            transform: translate(-50%, -50%);
            transition: width 0.3s ease, height 0.3s ease;
        }

        .nav-menu-item:active::before {
            width: 300px;
            height: 300px;
        }

        .nav-menu-item:hover {
            background: #eeeeee;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }

        .nav-menu-item.active {
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 100%);
            color: white;
            border-color: #2196F3;
        }

        .nav-menu-item.active .nav-menu-icon {
            color: white;
        }

        .nav-menu-item.active:hover {
            background: linear-gradient(135deg, #1565C0 0%, #1976D2 100%);
        }

        .nav-menu-icon {
            width: 48px;
            height: 48px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(33, 150, 243, 0.1);
            border-radius: 12px;
            color: #2196F3;
            transition: all 0.2s ease;
            position: relative;
            z-index: 1;
        }

        .nav-menu-item.active .nav-menu-icon {
            background: rgba(255, 255, 255, 0.2);
        }

        .nav-menu-label {
            font-size: 14px;
            font-weight: 500;
            color: #424242;
            position: relative;
            z-index: 1;
        }

        .nav-menu-item.active .nav-menu-label {
            color: white;
        }

        .nav-menu-item svg {
            transition: transform 0.2s ease;
        }

        .nav-menu-item:hover svg {
            transform: scale(1.1);
        }

        /* Main Content */
        main {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 16px 80px;
        }

        /* Status Header */
        .status-header {
            text-align: center;
            margin-bottom: 40px;
            padding: 32px 16px 24px;
            animation: fadeInDown 0.6s ease-out;
            position: relative;
        }

        .status-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 50%, #42A5F5 100%);
            border-radius: 2px;
        }

        .status-header h2 {
            font-size: 32px;
            background: linear-gradient(135deg, #1565C0 0%, #2196F3 50%, #42A5F5 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 12px;
            font-weight: 700;
            letter-spacing: -0.5px;
            line-height: 1.2;
            position: relative;
            display: inline-block;
            padding: 0 24px;
        }

        .status-header h2::after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 100%);
            border-radius: 2px;
        }

        /* Form Modern */
        .form-modern {
            background: linear-gradient(135deg, #FFFFFF 0%, #F5F9FF 100%);
            padding: 24px;
            border-radius: 16px;
            box-shadow: 0 2px 8px rgba(33, 150, 243, 0.1);
            margin-bottom: 24px;
            border: 1px solid rgba(33, 150, 243, 0.1);
            animation: fadeInUp 0.4s ease-out;
        }

        .form-group-modern {
            margin-bottom: 24px;
        }

        .form-group-modern label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: #424242;
            font-size: 14px;
            letter-spacing: 0.15px;
        }

        .form-group-modern input {
            width: 100%;
            padding: 16px;
            border: 1px solid #BDBDBD;
            border-radius: 8px;
            font-size: 16px;
            font-family: inherit;
            transition: all 0.2s cubic-bezier(0.4, 0.0, 0.2, 1);
            background: white;
            color: #212121;
            -webkit-appearance: none;
            appearance: none;
            box-sizing: border-box;
        }

        .form-group-modern input:focus {
            outline: none;
            border-color: #2196F3;
            border-width: 2px;
            padding: 15px;
        }

        .form-actions {
            display: flex;
            gap: 12px;
            margin-top: 24px;
        }

        .btn-modern {
            flex: 1;
            min-width: 120px;
            padding: 14px 24px;
            border: none;
            border-radius: 24px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s cubic-bezier(0.4, 0.0, 0.2, 1);
            position: relative;
            overflow: hidden;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.2);
            -webkit-tap-highlight-color: transparent;
            touch-action: manipulation;
        }

        .btn-primary-modern {
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 100%);
            color: white;
        }

        .btn-primary-modern:hover {
            background: linear-gradient(135deg, #1565C0 0%, #1976D2 100%);
            box-shadow: 0 4px 8px rgba(33, 150, 243, 0.4);
        }

        .btn-primary-modern:active {
            box-shadow: 0 1px 2px rgba(33, 150, 243, 0.4);
            transform: scale(0.98);
        }

        .btn-wa-modern {
            background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);
            color: white;
            border: none;
            width: 100%;
            max-width: 300px;
        }

        .btn-wa-modern:hover {
            background: linear-gradient(135deg, #128C7E 0%, #075E54 100%);
            box-shadow: 0 4px 8px rgba(37, 211, 102, 0.4);
        }

        .btn-wa-modern:active {
            box-shadow: 0 1px 2px rgba(37, 211, 102, 0.4);
            transform: scale(0.98);
        }

        /* Alert Modern */
        .alert-modern {
            padding: 16px;
            margin-bottom: 24px;
            border-radius: 8px;
            border-left: 4px solid;
            animation: slideInRight 0.3s ease-out;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .alert-error-modern {
            background-color: #FFEBEE;
            color: #C62828;
            border-color: #EF5350;
        }

        .alert-success-modern {
            background-color: #E8F5E9;
            color: #2E7D32;
            border-color: #66BB6A;
        }

        /* Ticket Detail */
        .ticket-detail {
            background: linear-gradient(135deg, #FFFFFF 0%, #F5F9FF 100%);
            padding: 24px;
            border-radius: 16px;
            box-shadow: 0 2px 8px rgba(33, 150, 243, 0.1);
            border: 1px solid rgba(33, 150, 243, 0.1);
            animation: fadeInUp 0.4s ease-out;
        }

        .ticket-detail h3 {
            font-size: 24px;
            color: #2196F3;
            margin-bottom: 24px;
            font-weight: 600;
        }

        .ticket-detail h4 {
            font-size: 18px;
            color: #2196F3;
            margin-top: 32px;
            margin-bottom: 16px;
            font-weight: 600;
        }

        .detail-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 24px;
        }

        .detail-table tr {
            border-bottom: 1px solid rgba(33, 150, 243, 0.1);
        }

        .detail-table tr:last-child {
            border-bottom: none;
        }

        .detail-table th {
            padding: 12px 16px;
            text-align: left;
            font-weight: 600;
            color: #424242;
            width: 180px;
            vertical-align: top;
        }

        .detail-table td {
            padding: 12px 16px;
            color: #616161;
            vertical-align: top;
        }

        /* Badge Modern */
        .badge-modern {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .badge-pending {
            background-color: #FFF3E0;
            color: #E65100;
        }

        .badge-assigned {
            background-color: #E3F2FD;
            color: #1565C0;
        }

        .badge-forwarded {
            background-color: #F3E5F5;
            color: #6A1B9A;
        }

        .badge-in_progress {
            background-color: #E1F5FE;
            color: #0277BD;
        }

        .badge-resolved {
            background-color: #E8F5E9;
            color: #2E7D32;
        }

        .badge-rejected {
            background-color: #FFEBEE;
            color: #C62828;
        }

        .badge-low {
            background-color: #ECEFF1;
            color: #455A64;
        }

        .badge-medium {
            background-color: #FFF9C4;
            color: #F57F17;
        }

        .badge-high {
            background-color: #FFE0B2;
            color: #E65100;
        }

        .badge-urgent {
            background-color: #FFCDD2;
            color: #C62828;
        }

        /* Comments */
        .comments {
            margin-top: 24px;
        }

        .comment-modern {
            background: #F5F9FF;
            padding: 16px;
            border-radius: 12px;
            margin-bottom: 16px;
            border-left: 4px solid #2196F3;
            box-shadow: 0 1px 3px rgba(33, 150, 243, 0.1);
        }

        .comment-modern strong {
            color: #2196F3;
            font-size: 14px;
            font-weight: 600;
        }

        .comment-date {
            color: #757575;
            font-size: 12px;
            margin-left: 12px;
        }

        .comment-modern p {
            margin-top: 12px;
            color: #424242;
            line-height: 1.6;
        }

        .btn-sm-modern {
            display: inline-block;
            padding: 8px 16px;
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 100%);
            color: white;
            text-decoration: none;
            border-radius: 16px;
            font-size: 12px;
            font-weight: 500;
            margin-top: 8px;
            transition: all 0.2s ease;
        }

        .btn-sm-modern:hover {
            background: linear-gradient(135deg, #1565C0 0%, #1976D2 100%);
            transform: translateY(-2px);
            box-shadow: 0 2px 4px rgba(33, 150, 243, 0.3);
        }

        /* Footer */
        footer {
            background: white;
            color: #616161;
            text-align: center;
            padding: 20px 16px;
            font-size: 12px;
            position: sticky;
            bottom: 0;
            z-index: 100;
            box-shadow: 0 -2px 4px rgba(0,0,0,0.1);
            border-top: 1px solid rgba(33, 150, 243, 0.1);
        }

        footer p {
            margin: 0;
        }

        /* Animations */
        @keyframes fadeInDown {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(20px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        /* Mobile Responsive */
        @media (max-width: 768px) {
            .nav-menu-container {
                padding: 12px;
            }

            .nav-menu-grid {
                display: grid;
                grid-template-columns: repeat(3, 1fr);
                gap: 8px;
                width: 100%;
                max-width: 100%;
            }

            .nav-menu-item {
                padding: 12px 8px;
                min-width: 0;
                width: 100%;
                box-sizing: border-box;
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
                min-height: 90px;
            }

            .nav-menu-icon {
                width: 36px;
                height: 36px;
                margin: 0 auto;
            }

            .nav-menu-icon svg {
                width: 20px;
                height: 20px;
            }

            .nav-menu-label {
                font-size: 11px;
                text-align: center;
                white-space: normal;
                word-wrap: break-word;
                line-height: 1.2;
                margin-top: 4px;
            }

            .status-header {
                padding: 24px 16px 20px;
                margin-bottom: 32px;
            }

            .status-header::before {
                width: 60px;
                height: 3px;
            }

            .status-header h2 {
                font-size: 24px;
                padding: 0 16px;
            }

            .status-header h2::after {
                width: 50px;
                height: 2px;
            }

            .form-modern {
                padding: 20px 16px;
                border-radius: 12px;
            }

            .ticket-detail {
                padding: 20px 16px;
                border-radius: 12px;
            }

            .detail-table th,
            .detail-table td {
                padding: 10px 12px;
                font-size: 14px;
            }

            .detail-table th {
                width: 120px;
            }

            .btn-wa-modern {
                max-width: 100%;
            }
        }

        @media (max-width: 480px) {
            .app-title h1 {
                font-size: 18px;
            }

            .nav-menu-container {
                padding: 8px;
            }

            .nav-menu-grid {
                gap: 6px;
            }

            .nav-menu-item {
                padding: 10px 6px;
            }

            .nav-menu-icon {
                width: 32px;
                height: 32px;
            }

            .nav-menu-icon svg {
                width: 18px;
                height: 18px;
            }

            .nav-menu-label {
                font-size: 10px;
            }

            .status-header {
                padding: 20px 12px 16px;
            }

            .status-header::before {
                width: 50px;
                height: 2px;
            }

            .status-header h2 {
                font-size: 20px;
                padding: 0 12px;
            }

            .status-header h2::after {
                width: 40px;
                height: 2px;
            }

            .form-modern {
                padding: 16px;
            }

            .ticket-detail {
                padding: 16px;
            }

            .detail-table {
                display: block;
            }

            .detail-table tr {
                display: block;
                margin-bottom: 12px;
                border-bottom: none;
            }

            .detail-table th,
            .detail-table td {
                display: block;
                padding: 8px 0;
                width: 100%;
            }

            .detail-table th {
                font-weight: 600;
                margin-bottom: 4px;
            }

            .btn-wa-modern {
                max-width: 100%;
                font-size: 13px;
                padding: 12px 20px;
            }

            footer {
                padding: 16px 12px;
                font-size: 11px;
            }

            main {
                padding-bottom: 60px;
            }
        }

        /* Smooth scroll */
        html {
            scroll-behavior: smooth;
        }
    </style>
</head>
<body>
    <!-- Android Style App Bar -->
    <div class="app-bar">
        <div class="app-bar-content">
            <div class="app-title">
                <svg class="app-icon" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                <h1>Halo Pemko Langsa</h1>
            </div>
        </div>
    </div>

    <!-- Android Style Navigation Menu -->
    <div class="nav-menu-container">
        <div class="nav-menu-grid">
            <a href="/halopemko/public/index.php" class="nav-menu-item">
                <div class="nav-menu-icon">
                    <svg width="28" height="28" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3 9L12 2L21 9V20C21 20.5304 20.7893 21.0391 20.4142 21.4142C20.0391 21.7893 19.5304 22 19 22H5C4.46957 22 3.96086 21.7893 3.58579 21.4142C3.21071 21.0391 3 20.5304 3 20V9Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M9 22V12H15V22" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <span class="nav-menu-label">Beranda</span>
            </a>

            <a href="/halopemko/public/index.php?action=report" class="nav-menu-item">
                <div class="nav-menu-icon">
                    <svg width="28" height="28" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M14 2H6C5.46957 2 4.96086 2.21071 4.58579 2.58579C4.21071 2.96086 4 3.46957 4 4V20C4 20.5304 4.21071 21.0391 4.58579 21.4142C4.96086 21.7893 5.46957 22 6 22H18C18.5304 22 19.0391 21.7893 19.4142 21.4142C19.7893 21.0391 20 20.5304 20 20V8L14 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M14 2V8H20" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M12 18V12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M9 15H15" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <span class="nav-menu-label">Buat Pengaduan</span>
            </a>

            <a href="/halopemko/public/index.php?action=status" class="nav-menu-item active">
                <div class="nav-menu-icon">
                    <svg width="28" height="28" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M9 12L11 14L15 10" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <span class="nav-menu-label">Cek Status</span>
            </a>
        </div>
    </div>

    <main>
        <div class="status-header">
            <h2>Cek Status Pengaduan</h2>
        </div>

        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert-modern alert-error-modern">
                <?php echo htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?>
            </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert-modern alert-success-modern">
                <?php echo htmlspecialchars($_SESSION['success']); unset($_SESSION['success']); ?>
                <div style="margin-top: 12px;">
                    <button id="backToWA" class="btn-modern btn-wa-modern" style="margin-top: 8px;">
                        <span>Kembali ke WA Halo Pemko</span>
                    </button>
                    <div id="info" style="margin-top: 8px; font-size: 12px; color: #2E7D32; display: none;"></div>
                </div>
            </div>
        <?php endif; ?>

        <form method="GET" action="/halopemko/public/index.php" class="form-modern">
            <input type="hidden" name="action" value="status">
            <div class="form-group-modern">
                <label for="ticket_no">Nomor Tiket</label>
                <input type="text" id="ticket_no" name="ticket_no" 
                       placeholder="Contoh: HPL-20240101-1234" 
                       value="<?php echo isset($_GET['ticket_no']) ? htmlspecialchars($_GET['ticket_no']) : ''; ?>" 
                       required>
            </div>
            <div class="form-actions">
                <button type="submit" class="btn-modern btn-primary-modern">Cek Status</button>
            </div>
        </form>

        <?php if (isset($ticket) && $ticket): ?>
            <div class="ticket-detail">
                <h3>Detail Pengaduan</h3>
                <table class="detail-table">
                    <tr>
                        <th>Nomor Tiket</th>
                        <td><?php echo htmlspecialchars($ticket['ticket_no']); ?></td>
                    </tr>
                    <tr>
                        <th>Status</th>
                        <td>
                            <span class="badge-modern badge-<?php echo $ticket['status']; ?>">
                                <?php 
                                $statusLabels = [
                                    'pending' => 'Menunggu Tindaklanjut',
                                    'assigned' => 'Ditugaskan',
                                    'forwarded' => 'Diteruskan ke PIC OPD',
                                    'in_progress' => 'Diproses',
                                    'resolved' => 'Selesai',
                                    'rejected' => 'Ditolak'
                                ];
                                echo $statusLabels[$ticket['status']] ?? $ticket['status'];
                                ?>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Prioritas</th>
                        <td>
                            <span class="badge-modern badge-<?php echo $ticket['priority']; ?>">
                                <?php 
                                $priorityLabels = [
                                    'low' => 'Rendah',
                                    'medium' => 'Sedang',
                                    'high' => 'Tinggi',
                                    'urgent' => 'Urgent'
                                ];
                                echo $priorityLabels[$ticket['priority']] ?? $ticket['priority'];
                                ?>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Pelapor</th>
                        <td><?php echo htmlspecialchars($ticket['reporter_name']); ?></td>
                    </tr>
                    <tr>
                        <th>Telepon</th>
                        <td><?php echo htmlspecialchars($ticket['reporter_phone']); ?></td>
                    </tr>
                    <tr>
                        <th>Judul</th>
                        <td><?php echo htmlspecialchars($ticket['subject']); ?></td>
                    </tr>
                    <tr>
                        <th>Deskripsi</th>
                        <td><?php echo nl2br(htmlspecialchars($ticket['description'])); ?></td>
                    </tr>
                    <?php if (!empty($ticket['attachment_path'])): ?>
                        <tr>
                            <th>Foto Pengaduan</th>
                            <td>
                                <a href="/halopemko/uploads/<?php echo htmlspecialchars($ticket['attachment_path']); ?>" target="_blank" class="btn-modern btn-secondary-modern" style="display: inline-flex; align-items: center; gap: 8px; padding: 10px 16px; text-transform: none;">
                                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M4 21V5C4 4.46957 4.21071 3.96086 4.58579 3.58579C4.96086 3.21071 5.46957 3 6 3H14L20 9V21C20 21.5304 19.7893 22.0391 19.4142 22.4142C19.0391 22.7893 18.5304 23 18 23H6C5.46957 23 4.96086 22.7893 4.58579 22.4142C4.21071 22.0391 4 21.5304 4 21Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M14 3V9H20" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M9 13L11 15L15 11" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                    <span>Lihat Foto</span>
                                </a>
                            </td>
                        </tr>
                    <?php endif; ?>
                    <tr>
                        <th>Ditugaskan ke</th>
                        <td><?php echo $ticket['assigned_name'] ? htmlspecialchars($ticket['assigned_name']) : '-'; ?></td>
                    </tr>
                    <tr>
                        <th>Tanggal Dibuat</th>
                        <td><?php echo date('d/m/Y H:i', strtotime($ticket['created_at'])); ?></td>
                    </tr>
                </table>

                <?php if (!empty($comments)): ?>
                    <h4>Komentar & Bukti</h4>
                    <div class="comments">
                        <?php foreach ($comments as $comment): ?>
                            <div class="comment-modern">
                                <strong><?php echo htmlspecialchars($comment['user_name']); ?></strong>
                                <span class="comment-date"><?php echo date('d/m/Y H:i', strtotime($comment['created_at'])); ?></span>
                                <p><?php echo nl2br(htmlspecialchars($comment['comment'])); ?></p>
                                <?php if ($comment['attachment_path']): ?>
                                    <a href="/halopemko/uploads/<?php echo htmlspecialchars($comment['attachment_path']); ?>" 
                                       target="_blank" class="btn-sm-modern">Lihat Bukti</a>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php elseif (isset($ticket) && $ticket === false && isset($_GET['ticket_no'])): ?>
            <div class="alert-modern alert-error-modern">
                Tiket tidak ditemukan. Pastikan nomor tiket yang Anda masukkan benar.
            </div>
        <?php endif; ?>
    </main>

    <footer>
        <p>&copy; <?php echo date('Y'); ?> Halo Pemko Kota Langsa. All rights reserved.</p>
    </footer>

    <script>
        // WhatsApp integration script
        // Sesuaikan: nomor tujuan (format internasional tanpa + atau 0), dan teks opsional
        const targetNumber = "<?php echo htmlspecialchars($whatsappNumber ?? '62812180022', ENT_QUOTES, 'UTF-8'); ?>";
        const messageText = encodeURIComponent("");

        const btn = document.getElementById("backToWA");
        const info = document.getElementById("info");

        function openWhatsApp() {
            // 1) Try app deep link first (works jika WhatsApp terpasang)
            const appLink = `whatsapp://send?phone=${targetNumber}&text=${messageText}`;

            // 2) Fallback web link (works di desktop / bila app tidak ada)
            const webLink = `https://wa.me/${targetNumber}?text=${messageText}`;
            const webLinkAlt = `https://web.whatsapp.com/send?phone=${targetNumber}&text=${messageText}`;

            // 3) For Android extra fallback using intent (optional)
            const intentLink = `intent://send/?phone=${targetNumber}&text=${messageText}#Intent;scheme=whatsapp;package=com.whatsapp;end`;

            // Cara aman: coba buka appLink, lalu jika tidak respons dalam 1s, fallback.
            // Note: behavior berbeda-beda antar browser; ini adalah pendekatan umum.
            const now = Date.now();
            let opened = false;

            // Create invisible iframe trick to open app scheme (safer in many mobile browsers)
            const iframe = document.createElement('iframe');
            iframe.style.display = 'none';
            iframe.src = appLink;
            document.body.appendChild(iframe);

            // Jika app terbuka, browser biasanya blur / suspend page -> kita may not get events.
            // Setelah timeout, jika tidak berhasil, ganti ke web fallback.
            setTimeout(() => {
                document.body.removeChild(iframe);
                if (Date.now() - now < 1500) {
                    // kemungkinan app tidak terbuka → redirect ke web WhatsApp
                    // Pilih webLink untuk mobile, webLinkAlt untuk desktop (deteksi sederhana)
                    const isDesktop = !/Mobi|Android/i.test(navigator.userAgent);
                    const redirect = isDesktop ? webLinkAlt : webLink;
                    window.location.href = redirect;
                }
            }, 1200);

            // Opsional: untuk Android Chrome, gunakan intent jika ingin lebih reliable:
            // window.location.href = intentLink; // hati-hati — bisa memunculkan error di beberapa browser
        }

        // Only add event listener if button exists
        if (btn) {
            btn.addEventListener('click', () => {
                // Jika halaman dibuka di in-app browser WA, deep link akan menutup webview dan kembali.
                // Beri info ke user saat fallback.
                if (info) {
                    info.style.display = 'block';
                    info.textContent = "Mencoba membuka WhatsApp... Jika tidak terbuka, akan diarahkan ke WhatsApp Web.";
                }
                openWhatsApp();
            });
        }
    </script>
</body>
</html>
