<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buat Pengaduan - Halo Pemko Kota Langsa</title>
    <link rel="stylesheet" href="/halopemko/public/assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        /* Android Material Design Report Page Styles */
        * {
            font-family: 'Roboto', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
        }

        .report-page {
            background: #F5F5F5;
            min-height: 100vh;
            padding: 0;
        }

        /* Android App Bar */
        .app-bar {
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 50%, #42A5F5 100%);
            color: white;
            padding: 16px 0;
            box-shadow: 0 2px 4px rgba(0,0,0,0.2);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .app-bar-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 16px;
        }

        .app-title {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
        }

        .app-icon {
            color: white;
        }

        .app-title h1 {
            font-size: 20px;
            font-weight: 500;
            margin: 0;
            color: white;
            text-align: center;
        }

        /* Android Navigation Menu */
        .nav-menu-container {
            background: linear-gradient(135deg, #FFFFFF 0%, #F0F7FF 100%);
            padding: 16px;
            box-shadow: 0 2px 4px rgba(33, 150, 243, 0.1);
            margin-bottom: 16px;
            border-bottom: 1px solid rgba(33, 150, 243, 0.1);
        }

        .nav-menu-grid {
            max-width: 900px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 12px;
        }

        /* Mobile Responsive Grid - All items visible */
        @media (max-width: 768px) {
            .nav-menu-container {
                padding: 12px;
            }

            .nav-menu-grid {
                display: grid;
                grid-template-columns: repeat(3, 1fr);
                gap: 8px;
                width: 100%;
                max-width: 100%;
            }

            .nav-menu-item {
                padding: 12px 8px;
                min-width: 0;
                width: 100%;
                box-sizing: border-box;
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
                min-height: 90px;
            }

            .nav-menu-icon {
                width: 36px;
                height: 36px;
                margin: 0 auto;
            }

            .nav-menu-icon svg {
                width: 20px;
                height: 20px;
            }

            .nav-menu-label {
                font-size: 11px;
                text-align: center;
                white-space: normal;
                word-wrap: break-word;
                line-height: 1.2;
                margin-top: 4px;
            }
        }

        .nav-menu-item {
            background: #f5f5f5;
            border-radius: 16px;
            padding: 20px 16px;
            text-decoration: none;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 12px;
            transition: all 0.2s cubic-bezier(0.4, 0.0, 0.2, 1);
            cursor: pointer;
            border: 2px solid transparent;
            position: relative;
            overflow: hidden;
            -webkit-tap-highlight-color: transparent;
            touch-action: manipulation;
        }

        .nav-menu-item::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(33, 150, 243, 0.1);
            transform: translate(-50%, -50%);
            transition: width 0.3s ease, height 0.3s ease;
        }

        .nav-menu-item:active::before {
            width: 300px;
            height: 300px;
        }

        .nav-menu-item:hover {
            background: #eeeeee;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }

        .nav-menu-item.active {
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 100%);
            color: white;
            border-color: #2196F3;
        }

        .nav-menu-item.active .nav-menu-icon {
            color: white;
        }

        .nav-menu-item.active:hover {
            background: linear-gradient(135deg, #1565C0 0%, #1976D2 100%);
        }

        .nav-menu-icon {
            width: 48px;
            height: 48px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(33, 150, 243, 0.1);
            border-radius: 12px;
            color: #2196F3;
            transition: all 0.2s ease;
            position: relative;
            z-index: 1;
        }

        .nav-menu-item.active .nav-menu-icon {
            background: rgba(255, 255, 255, 0.2);
        }

        .nav-menu-label {
            font-size: 14px;
            font-weight: 500;
            color: #424242;
            position: relative;
            z-index: 1;
        }

        .nav-menu-item.active .nav-menu-label {
            color: white;
        }

        .nav-menu-item svg {
            transition: transform 0.2s ease;
        }

        .nav-menu-item:hover svg {
            transform: scale(1.1);
        }

        .report-header {
            text-align: center;
            margin-bottom: 40px;
            padding: 32px 16px 24px;
            animation: fadeInDown 0.6s ease-out;
            position: relative;
        }

        .report-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 50%, #42A5F5 100%);
            border-radius: 2px;
        }

        .report-header h2 {
            font-size: 32px;
            background: linear-gradient(135deg, #1565C0 0%, #2196F3 50%, #42A5F5 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 12px;
            font-weight: 700;
            letter-spacing: -0.5px;
            line-height: 1.2;
            position: relative;
            display: inline-block;
            padding: 0 24px;
        }

        .report-header h2::after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 100%);
            border-radius: 2px;
        }

        .report-header p {
            color: #616161;
            font-size: 15px;
            margin-top: 16px;
            font-weight: 400;
            letter-spacing: 0.3px;
        }

        .report-form-wrapper {
            max-width: 900px;
            margin: 0 auto;
            padding: 0 16px 24px;
            animation: fadeInUp 0.4s ease-out;
        }

        .form-modern {
            background: white;
            padding: 28px;
            border-radius: 20px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08), 0 1px 3px rgba(0,0,0,0.05);
            border: 1px solid rgba(33, 150, 243, 0.08);
            transition: box-shadow 0.2s ease;
        }

        .form-modern:hover {
            box-shadow: 0 4px 16px rgba(0,0,0,0.12), 0 2px 6px rgba(0,0,0,0.08);
        }

        .form-group-modern {
            margin-bottom: 24px;
            position: relative;
        }

        .form-group-modern label {
            display: block;
            margin-bottom: 10px;
            font-weight: 600;
            color: #212121;
            font-size: 14px;
            letter-spacing: 0.1px;
            text-transform: none;
        }

        .form-group-modern input,
        .form-group-modern select,
        .form-group-modern textarea {
            width: 100%;
            padding: 16px;
            border: 1.5px solid #E0E0E0;
            border-radius: 12px;
            font-size: 16px;
            font-family: inherit;
            transition: all 0.2s cubic-bezier(0.4, 0.0, 0.2, 1);
            background: #FAFAFA;
            color: #212121;
            -webkit-appearance: none;
            appearance: none;
        }

        .form-group-modern input:focus,
        .form-group-modern select:focus,
        .form-group-modern textarea:focus {
            outline: none;
            background: white;
            border-color: #2196F3;
            border-width: 2px;
            padding: 15px;
            box-shadow: 0 0 0 4px rgba(33, 150, 243, 0.1);
        }

        .form-group-modern textarea {
            resize: vertical;
            min-height: 120px;
            font-family: inherit;
        }

        .form-group-modern select {
            cursor: pointer;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24' fill='none'%3E%3Cpath d='M6 9L12 15L18 9' stroke='%232196F3' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 16px center;
            padding-right: 48px;
        }

        .form-actions {
            display: flex;
            gap: 12px;
            margin-top: 32px;
            flex-wrap: wrap;
        }

        .btn-modern {
            flex: 1;
            min-width: 120px;
            padding: 14px 24px;
            border: none;
            border-radius: 24px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s cubic-bezier(0.4, 0.0, 0.2, 1);
            position: relative;
            overflow: hidden;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.2);
            -webkit-tap-highlight-color: transparent;
            touch-action: manipulation;
        }

        .btn-modern::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.3);
            transform: translate(-50%, -50%);
            transition: width 0.3s ease, height 0.3s ease;
        }

        .btn-modern:active::before {
            width: 300px;
            height: 300px;
        }

        .btn-modern span {
            position: relative;
            z-index: 1;
        }

        .btn-primary-modern {
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 100%);
            color: white;
        }

        .btn-primary-modern:hover {
            background: linear-gradient(135deg, #1565C0 0%, #1976D2 100%);
            box-shadow: 0 4px 8px rgba(33, 150, 243, 0.4);
        }

        .btn-primary-modern:active {
            box-shadow: 0 1px 2px rgba(33, 150, 243, 0.4);
            transform: scale(0.98);
        }

        .btn-secondary-modern {
            background: white;
            color: #2196F3;
            border: 1px solid #2196F3;
        }

        .btn-secondary-modern:hover {
            background: rgba(33, 150, 243, 0.08);
        }

        .btn-secondary-modern:active {
            background: rgba(33, 150, 243, 0.12);
            transform: scale(0.98);
        }

        .alert-modern {
            padding: 16px;
            margin-bottom: 24px;
            border-radius: 8px;
            border-left: 4px solid;
            animation: slideInRight 0.3s ease-out;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .alert-error-modern {
            background-color: #FFEBEE;
            color: #C62828;
            border-color: #EF5350;
        }

        /* Animations */
        @keyframes fadeInDown {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }
            to {
                opacity: 1;
            }
        }

        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(20px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        /* Container */
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0;
        }

        /* Main Content */
        main {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 0 80px 0;
        }

        /* Footer */
        footer {
            background: white;
            color: #616161;
            text-align: center;
            padding: 20px 16px;
            font-size: 12px;
            position: sticky;
            bottom: 0;
            z-index: 100;
            box-shadow: 0 -2px 4px rgba(0,0,0,0.1);
            border-top: 1px solid rgba(33, 150, 243, 0.1);
        }

        footer p {
            margin: 0;
        }

        /* Mobile Responsive - Additional Styles */
        @media (max-width: 768px) {
            .report-header {
                padding: 24px 16px 20px;
                margin-bottom: 32px;
            }

            .report-header::before {
                width: 60px;
                height: 3px;
            }

            .report-header h2 {
                font-size: 24px;
                padding: 0 16px;
            }

            .report-header h2::after {
                width: 50px;
                height: 2px;
            }

            .report-header p {
                font-size: 13px;
                margin-top: 12px;
            }

            .form-modern {
                padding: 20px 16px;
                border-radius: 12px;
            }

            .form-group-modern {
                margin-bottom: 20px;
            }

            .form-group-modern input,
            .form-group-modern select,
            .form-group-modern textarea {
                padding: 14px;
                font-size: 16px; /* Prevents zoom on iOS */
            }

            .form-actions {
                flex-direction: column;
            }

            .btn-modern {
                width: 100%;
                min-width: auto;
            }
        }

        @media (max-width: 480px) {
            .report-header {
                padding: 20px 12px 16px;
            }

            .report-header::before {
                width: 50px;
                height: 2px;
            }

            .report-header h2 {
                font-size: 20px;
                padding: 0 12px;
            }

            .report-header h2::after {
                width: 40px;
                height: 2px;
            }

            .report-header p {
                font-size: 12px;
            }

            .form-modern {
                padding: 16px;
            }

            .app-title h1 {
                font-size: 18px;
            }

            .nav-menu-container {
                padding: 8px;
            }

            .nav-menu-grid {
                gap: 6px;
            }

            .nav-menu-item {
                padding: 10px 6px;
            }

            .nav-menu-icon {
                width: 32px;
                height: 32px;
            }

            .nav-menu-icon svg {
                width: 18px;
                height: 18px;
            }

            .nav-menu-label {
                font-size: 10px;
            }

            footer {
                padding: 16px 12px;
                font-size: 11px;
            }

            main {
                padding-bottom: 60px;
            }
        }

        /* Smooth scroll */
        html {
            scroll-behavior: smooth;
        }

        /* Loading state for submit button */
        .btn-modern.loading {
            pointer-events: none;
            opacity: 0.7;
        }

        .btn-modern.loading::after {
            content: '';
            position: absolute;
            width: 16px;
            height: 16px;
            top: 50%;
            left: 50%;
            margin-left: -8px;
            margin-top: -8px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-top-color: white;
            border-radius: 50%;
            animation: spin 0.6s linear infinite;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        /* Collapsible Section Styles - Android Material Design */
        .collapsible-section {
            margin-bottom: 16px;
            background: white;
            border-radius: 12px;
            border: 1px solid #E0E0E0;
            overflow: hidden;
            transition: all 0.3s cubic-bezier(0.4, 0.0, 0.2, 1);
            box-shadow: 0 1px 3px rgba(0,0,0,0.08);
        }

        .collapsible-section:hover {
            box-shadow: 0 2px 6px rgba(0,0,0,0.12);
        }

        .collapsible-toggle {
            width: 100%;
            padding: 16px 20px;
            background: transparent;
            border: none;
            display: flex;
            align-items: center;
            gap: 12px;
            cursor: pointer;
            text-align: left;
            font-family: inherit;
            transition: all 0.2s cubic-bezier(0.4, 0.0, 0.2, 1);
            -webkit-tap-highlight-color: transparent;
            touch-action: manipulation;
            position: relative;
        }

        .collapsible-toggle:active {
            background: rgba(33, 150, 243, 0.08);
        }

        .collapsible-toggle[aria-expanded="true"] {
            background: rgba(33, 150, 243, 0.05);
        }

        .toggle-icon {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: rgba(33, 150, 243, 0.1);
            border-radius: 20px;
            color: #2196F3;
            flex-shrink: 0;
            transition: all 0.2s ease;
        }

        .collapsible-toggle[aria-expanded="true"] .toggle-icon {
            background: rgba(33, 150, 243, 0.2);
            color: #1976D2;
        }

        .toggle-label {
            flex: 1;
            font-size: 15px;
            font-weight: 500;
            color: #424242;
            letter-spacing: 0.15px;
        }

        .collapsible-toggle[aria-expanded="true"] .toggle-label {
            color: #1976D2;
            font-weight: 600;
        }

        .toggle-arrow {
            display: flex;
            align-items: center;
            justify-content: center;
            color: #757575;
            transition: transform 0.3s cubic-bezier(0.4, 0.0, 0.2, 1);
            flex-shrink: 0;
        }

        .collapsible-toggle[aria-expanded="true"] .toggle-arrow {
            transform: rotate(180deg);
            color: #2196F3;
        }

        .collapsible-content {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s cubic-bezier(0.4, 0.0, 0.2, 1), padding 0.3s ease;
            padding: 0 20px;
        }

        .collapsible-content.expanded {
            max-height: 500px;
            padding: 0 20px 20px;
        }

        .collapsible-content .form-group-modern {
            margin-bottom: 0;
            margin-top: 16px;
        }

        /* Address Notice Banner - Very Attention Grabbing */
        .address-notice-banner {
            background: linear-gradient(135deg, #FF6B35 0%, #F7931E 50%, #FFB347 100%);
            border-radius: 16px;
            padding: 20px;
            margin: 24px 0;
            display: flex;
            gap: 16px;
            align-items: flex-start;
            box-shadow: 0 4px 12px rgba(255, 107, 53, 0.4), 0 0 0 3px rgba(255, 107, 53, 0.2);
            animation: pulseGlow 2s ease-in-out infinite;
            position: relative;
            overflow: hidden;
        }

        .address-notice-banner::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.1), transparent);
            animation: shimmer 3s infinite;
        }

        @keyframes pulseGlow {
            0%, 100% {
                box-shadow: 0 4px 12px rgba(255, 107, 53, 0.4), 0 0 0 3px rgba(255, 107, 53, 0.2);
            }
            50% {
                box-shadow: 0 6px 20px rgba(255, 107, 53, 0.6), 0 0 0 4px rgba(255, 107, 53, 0.3);
            }
        }

        @keyframes shimmer {
            0% {
                transform: translateX(-100%) translateY(-100%) rotate(45deg);
            }
            100% {
                transform: translateX(100%) translateY(100%) rotate(45deg);
            }
        }

        .notice-icon {
            flex-shrink: 0;
            width: 48px;
            height: 48px;
            background: rgba(255, 255, 255, 0.25);
            border-radius: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            animation: bounce 2s ease-in-out infinite;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
        }

        @keyframes bounce {
            0%, 100% {
                transform: translateY(0);
            }
            50% {
                transform: translateY(-5px);
            }
        }

        .notice-content {
            flex: 1;
            position: relative;
            z-index: 1;
        }

        .notice-title {
            font-size: 16px;
            font-weight: 700;
            color: white;
            margin-bottom: 8px;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
            letter-spacing: 0.3px;
            line-height: 1.4;
        }

        .notice-text {
            font-size: 14px;
            color: rgba(255, 255, 255, 0.95);
            line-height: 1.5;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        }


        /* Mobile Responsive for Collapsible */
        @media (max-width: 768px) {
            .address-notice-banner {
                padding: 16px;
                margin: 20px 0;
                border-radius: 12px;
            }

            .notice-icon {
                width: 40px;
                height: 40px;
            }

            .notice-title {
                font-size: 14px;
            }

            .notice-text {
                font-size: 13px;
            }

            .collapsible-toggle {
                padding: 14px 16px;
            }

            .toggle-icon {
                width: 36px;
                height: 36px;
            }

            .toggle-label {
                font-size: 14px;
            }

            .collapsible-content {
                padding: 0 16px;
            }

            .collapsible-content.expanded {
                padding: 0 16px 16px;
            }
        }

        @media (max-width: 480px) {
            .address-notice-banner {
                padding: 14px;
                flex-direction: column;
                text-align: center;
            }

            .notice-icon {
                margin: 0 auto;
            }

            .collapsible-toggle {
                padding: 12px 14px;
                gap: 10px;
            }

            .toggle-icon {
                width: 32px;
                height: 32px;
            }

            .toggle-label {
                font-size: 13px;
            }
        }
    </style>
</head>
<body class="report-page">
    <!-- Android Style App Bar -->
    <div class="app-bar">
        <div class="app-bar-content">
            <div class="app-title">
                <svg class="app-icon" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                <h1>Halo Pemko Langsa</h1>
            </div>
        </div>
    </div>

    <!-- Android Style Navigation Menu -->
    <div class="nav-menu-container">
        <div class="nav-menu-grid">
            <a href="/halopemko/public/index.php" class="nav-menu-item">
                <div class="nav-menu-icon">
                    <svg width="28" height="28" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3 9L12 2L21 9V20C21 20.5304 20.7893 21.0391 20.4142 21.4142C20.0391 21.7893 19.5304 22 19 22H5C4.46957 22 3.96086 21.7893 3.58579 21.4142C3.21071 21.0391 3 20.5304 3 20V9Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M9 22V12H15V22" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <span class="nav-menu-label">Beranda</span>
            </a>

            <a href="/halopemko/public/index.php?action=report" class="nav-menu-item active">
                <div class="nav-menu-icon">
                    <svg width="28" height="28" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M14 2H6C5.46957 2 4.96086 2.21071 4.58579 2.58579C4.21071 2.96086 4 3.46957 4 4V20C4 20.5304 4.21071 21.0391 4.58579 21.4142C4.96086 21.7893 5.46957 22 6 22H18C18.5304 22 19.0391 21.7893 19.4142 21.4142C19.7893 21.0391 20 20.5304 20 20V8L14 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M14 2V8H20" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M12 18V12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M9 15H15" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <span class="nav-menu-label">Buat Pengaduan</span>
            </a>

            <a href="/halopemko/public/index.php?action=status" class="nav-menu-item">
                <div class="nav-menu-icon">
                    <svg width="28" height="28" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M9 12L11 14L15 10" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <span class="nav-menu-label">Cek Status</span>
            </a>
        </div>
    </div>

    <main>
        <div class="report-header">
            <h2>Form Pengaduan Masyarakat</h2>
            <p>Lengkapi data di bawah ini untuk mengajukan pengaduan Anda</p>
        </div>

        <div class="report-form-wrapper">
            <?php if (isset($_SESSION['error'])): ?>
                <div class="alert-modern alert-error-modern">
                    <?php echo htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?>
                </div>
            <?php endif; ?>

            <form method="POST" action="/halopemko/public/index.php?action=report_submit" class="form-modern" id="reportForm" enctype="multipart/form-data">
                <div class="form-group-modern">
                    <label for="reporter_name">Nama Lengkap *</label>
                    <input type="text" id="reporter_name" name="reporter_name" required placeholder="Masukkan nama lengkap Anda">
                </div>

                <div class="form-group-modern">
                    <label for="reporter_phone">No. Telepon/HP *</label>
                    <input type="tel" id="reporter_phone" name="reporter_phone" required placeholder="Contoh: 081234567890">
                </div>

                <!-- Collapsible Email Field -->
                <div class="collapsible-section">
                    <button type="button" class="collapsible-toggle" id="emailToggle" aria-expanded="false">
                        <span class="toggle-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M4 4H20C21.1 4 22 4.9 22 6V18C22 19.1 21.1 20 20 20H4C2.9 20 2 19.1 2 18V6C2 4.9 2.9 4 4 4Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M22 6L12 13L2 6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </span>
                        <span class="toggle-label">Email (Opsional)</span>
                        <span class="toggle-arrow">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M6 9L12 15L18 9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </span>
                    </button>
                    <div class="collapsible-content" id="emailContent">
                        <div class="form-group-modern">
                            <label for="reporter_email">Email</label>
                            <input type="email" id="reporter_email" name="reporter_email" placeholder="email@example.com (opsional)">
                        </div>
                    </div>
                </div>

                <div class="form-group-modern">
                    <label for="subject">Judul Pengaduan *</label>
                    <input type="text" id="subject" name="subject" required placeholder="Ringkasan singkat pengaduan Anda">
                </div>

                <div class="form-group-modern">
                    <label for="category">Kategori</label>
                    <select id="category" name="category">
                        <option value="">Pilih Kategori</option>
                        <?php if (!empty($categories)): ?>
                            <?php foreach ($categories as $category): ?>
                                <option value="<?php echo htmlspecialchars($category['name']); ?>">
                                    <?php echo htmlspecialchars($category['name']); ?>
                                </option>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <option value="Lainnya">Lainnya</option>
                        <?php endif; ?>
                    </select>
                    <small style="display: block; margin-top: 5px; color: #666; font-size: 0.9em;">
                        Pilih kategori yang sesuai dengan pengaduan Anda
                    </small>
                </div>

                <div class="form-group-modern">
                    <label for="priority">Prioritas</label>
                    <select id="priority" name="priority">
                        <option value="low">Rendah</option>
                        <option value="medium" selected>Sedang</option>
                        <option value="high">Tinggi</option>
                        <option value="urgent">Urgent</option>
                    </select>
                </div>

                <div class="form-group-modern">
                    <label for="description">Deskripsi Pengaduan *</label>
                    <textarea id="description" name="description" rows="6" required placeholder="Jelaskan detail pengaduan Anda secara lengkap..."></textarea>
                </div>

                <!-- Address Notice Banner -->
                <div class="address-notice-banner" id="addressNotice">
                    <div class="notice-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12 2C8.13 2 5 5.13 5 9C5 14.25 12 22 12 22C12 22 19 14.25 19 9C19 5.13 15.87 2 12 2ZM12 11.5C11.3369 11.5 10.7011 11.2366 10.2322 10.7678C9.76339 10.2989 9.5 9.66304 9.5 9C9.5 8.33696 9.76339 7.70107 10.2322 7.23223C10.7011 6.76339 11.3369 6.5 12 6.5C12.663 6.5 13.2989 6.76339 13.7678 7.23223C14.2366 7.70107 14.5 8.33696 14.5 9C14.5 9.66304 14.2366 10.2989 13.7678 10.7678C13.2989 11.2366 12.663 11.5 12 11.5Z" fill="currentColor"/>
                        </svg>
                    </div>
                    <div class="notice-content">
                        <div class="notice-title">⚠️ PENTING: Jangan Lupa Alamat Lengkap!</div>
                        <div class="notice-text">Jika pengaduan Anda memerlukan tindak lanjut di lapangan, pastikan untuk mengisi alamat lengkap di bawah ini agar tim dapat segera menindaklanjuti.</div>
                    </div>
                </div>

                <!-- Collapsible Address Field -->
                <div class="collapsible-section">
                    <button type="button" class="collapsible-toggle" id="addressToggle" aria-expanded="false">
                        <span class="toggle-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M12 2C8.13 2 5 5.13 5 9C5 14.25 12 22 12 22C12 22 19 14.25 19 9C19 5.13 15.87 2 12 2ZM12 11.5C11.3369 11.5 10.7011 11.2366 10.2322 10.7678C9.76339 10.2989 9.5 9.66304 9.5 9C9.5 8.33696 9.76339 7.70107 10.2322 7.23223C10.7011 6.76339 11.3369 6.5 12 6.5C12.663 6.5 13.2989 6.76339 13.7678 7.23223C14.2366 7.70107 14.5 8.33696 14.5 9C14.5 9.66304 14.2366 10.2989 13.7678 10.7678C13.2989 11.2366 12.663 11.5 12 11.5Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </span>
                        <span class="toggle-label">Alamat Lengkap (Opsional)</span>
                        <span class="toggle-arrow">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M6 9L12 15L18 9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </span>
                    </button>
                    <div class="collapsible-content" id="addressContent">
                        <div class="form-group-modern">
                            <label for="reporter_address">Alamat Lengkap</label>
                            <textarea id="reporter_address" name="reporter_address" rows="4" placeholder="Masukkan alamat lengkap (Jalan, RT/RW, Kelurahan, Kecamatan, Kota)"></textarea>
                            <small style="display: block; margin-top: 8px; color: #FF6B35; font-size: 0.9em; font-weight: 500;">
                                💡 Penting: Alamat lengkap diperlukan untuk pengaduan yang memerlukan kunjungan lapangan
                            </small>
                        </div>
                    </div>
                </div>

                <div class="form-group-modern">
                    <label for="report_photo">Foto Pendukung</label>
                    <input type="file" id="report_photo" name="report_photo" accept="image/*">
                    <small style="display: block; margin-top: 5px; color: #666; font-size: 0.9em;">
                        Opsional. Unggah foto pendukung dalam format JPG, PNG, GIF, atau WEBP. Maksimum 5MB.
                    </small>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn-modern btn-primary-modern">
                        <span>Lapor Pak Wali</span>
                    </button>
                    <a href="/halopemko/public/index.php" class="btn-modern btn-secondary-modern">
                        <span>Batal</span>
                    </a>
                </div>
            </form>
        </div>
    </main>

    <footer>
        <p>&copy; <?php echo date('Y'); ?> Halo Pemko Kota Langsa. All rights reserved.</p>
    </footer>

    <script>
        // Form submission with loading state
        document.getElementById('reportForm').addEventListener('submit', function(e) {
            const submitBtn = this.querySelector('button[type="submit"]');
            submitBtn.classList.add('loading');
            submitBtn.disabled = true;
        });

        // Smooth focus animations
        const inputs = document.querySelectorAll('.form-group-modern input, .form-group-modern select, .form-group-modern textarea');
        inputs.forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.style.animation = 'none';
                setTimeout(() => {
                    this.parentElement.style.animation = 'fadeIn 0.3s ease';
                }, 10);
            });
        });

        // Collapsible Toggle Functionality - Android Native Style
        function initCollapsible(toggleId, contentId) {
            const toggle = document.getElementById(toggleId);
            const content = document.getElementById(contentId);
            
            if (!toggle || !content) return;

            toggle.addEventListener('click', function() {
                const isExpanded = this.getAttribute('aria-expanded') === 'true';
                
                // Toggle aria-expanded
                this.setAttribute('aria-expanded', !isExpanded);
                
                // Toggle expanded class
                if (isExpanded) {
                    content.classList.remove('expanded');
                } else {
                    content.classList.add('expanded');
                    // Smooth scroll to content if needed
                    setTimeout(() => {
                        content.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
                    }, 100);
                }
            });

            // Add ripple effect on click (Android Material Design)
            toggle.addEventListener('click', function(e) {
                const ripple = document.createElement('span');
                const rect = this.getBoundingClientRect();
                const size = Math.max(rect.width, rect.height);
                const x = e.clientX - rect.left - size / 2;
                const y = e.clientY - rect.top - size / 2;
                
                ripple.style.width = ripple.style.height = size + 'px';
                ripple.style.left = x + 'px';
                ripple.style.top = y + 'px';
                ripple.classList.add('ripple');
                
                this.appendChild(ripple);
                
                setTimeout(() => {
                    ripple.remove();
                }, 600);
            });
        }

        // Initialize collapsible sections
        document.addEventListener('DOMContentLoaded', function() {
            initCollapsible('emailToggle', 'emailContent');
            initCollapsible('addressToggle', 'addressContent');
        });

        // Add ripple effect styles
        const style = document.createElement('style');
        style.textContent = `
            .collapsible-toggle {
                position: relative;
                overflow: hidden;
            }
            .ripple {
                position: absolute;
                border-radius: 50%;
                background: rgba(33, 150, 243, 0.3);
                transform: scale(0);
                animation: ripple-animation 0.6s ease-out;
                pointer-events: none;
            }
            @keyframes ripple-animation {
                to {
                    transform: scale(4);
                    opacity: 0;
                }
            }
        `;
        document.head.appendChild(style);
    </script>
</body>
</html>

