<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Halo Pemko Kota Langsa - Pengaduan Masyarakat</title>
    <link rel="stylesheet" href="/halopemko/public/assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        /* Android Material Design Home Page Styles */
        * {
            font-family: 'Roboto', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
        }

        body {
            background: linear-gradient(135deg, #E3F2FD 0%, #BBDEFB 50%, #90CAF9 100%);
            min-height: 100vh;
            padding: 0;
            margin: 0;
        }

        /* Android App Bar */
        .app-bar {
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 50%, #42A5F5 100%);
            color: white;
            padding: 16px 0;
            box-shadow: 0 2px 4px rgba(0,0,0,0.2);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .app-bar-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 16px;
        }

        .app-title {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
        }

        .app-icon {
            color: white;
        }

        .app-title h1 {
            font-size: 20px;
            font-weight: 500;
            margin: 0;
            color: white;
            text-align: center;
        }

        /* Android Navigation Menu */
        .nav-menu-container {
            background: linear-gradient(135deg, #FFFFFF 0%, #F0F7FF 100%);
            padding: 16px;
            box-shadow: 0 2px 4px rgba(33, 150, 243, 0.1);
            margin-bottom: 16px;
            border-bottom: 1px solid rgba(33, 150, 243, 0.1);
        }

        .nav-menu-grid {
            max-width: 900px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 12px;
        }

        .nav-menu-item {
            background: #f5f5f5;
            border-radius: 16px;
            padding: 20px 16px;
            text-decoration: none;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 12px;
            transition: all 0.2s cubic-bezier(0.4, 0.0, 0.2, 1);
            cursor: pointer;
            border: 2px solid transparent;
            position: relative;
            overflow: hidden;
            -webkit-tap-highlight-color: transparent;
            touch-action: manipulation;
        }

        .nav-menu-item::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(33, 150, 243, 0.1);
            transform: translate(-50%, -50%);
            transition: width 0.3s ease, height 0.3s ease;
        }

        .nav-menu-item:active::before {
            width: 300px;
            height: 300px;
        }

        .nav-menu-item:hover {
            background: #eeeeee;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }

        .nav-menu-item.active {
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 100%);
            color: white;
            border-color: #2196F3;
        }

        .nav-menu-item.active .nav-menu-icon {
            color: white;
        }

        .nav-menu-item.active:hover {
            background: linear-gradient(135deg, #1565C0 0%, #1976D2 100%);
        }

        .nav-menu-icon {
            width: 48px;
            height: 48px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(33, 150, 243, 0.1);
            border-radius: 12px;
            color: #2196F3;
            transition: all 0.2s ease;
            position: relative;
            z-index: 1;
        }

        .nav-menu-item.active .nav-menu-icon {
            background: rgba(255, 255, 255, 0.2);
        }

        .nav-menu-label {
            font-size: 14px;
            font-weight: 500;
            color: #424242;
            position: relative;
            z-index: 1;
        }

        .nav-menu-item.active .nav-menu-label {
            color: white;
        }

        .nav-menu-item svg {
            transition: transform 0.2s ease;
        }

        .nav-menu-item:hover svg {
            transform: scale(1.1);
        }

        /* Main Content */
        main {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 16px 80px;
        }

        /* Hero Section */
        .hero {
            text-align: center;
            margin-bottom: 40px;
            padding: 32px 16px 24px;
            animation: fadeInDown 0.6s ease-out;
            position: relative;
        }

        .hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 50%, #42A5F5 100%);
            border-radius: 2px;
        }

        .hero h2 {
            font-size: 32px;
            background: linear-gradient(135deg, #1565C0 0%, #2196F3 50%, #42A5F5 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 12px;
            font-weight: 700;
            letter-spacing: -0.5px;
            line-height: 1.2;
            position: relative;
            display: inline-block;
            padding: 0 24px;
        }

        .hero h2::after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 100%);
            border-radius: 2px;
        }

        .hero p {
            color: #616161;
            font-size: 15px;
            margin-top: 16px;
            font-weight: 400;
            letter-spacing: 0.3px;
        }

        /* Features Section */
        .features {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 20px;
            margin-top: 40px;
            animation: fadeInUp 0.6s ease-out;
        }

        .feature-card {
            background: linear-gradient(135deg, #FFFFFF 0%, #F5F9FF 100%);
            padding: 32px 24px;
            border-radius: 16px;
            box-shadow: 0 2px 8px rgba(33, 150, 243, 0.1);
            transition: all 0.3s ease;
            border: 1px solid rgba(33, 150, 243, 0.1);
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .feature-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 100%);
        }

        .feature-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 16px rgba(33, 150, 243, 0.2);
        }

        .feature-card h3 {
            color: #2196F3;
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 12px;
        }

        .feature-card p {
            color: #616161;
            font-size: 14px;
            line-height: 1.6;
            margin-bottom: 20px;
        }

        .feature-card .btn {
            background: linear-gradient(135deg, #1976D2 0%, #2196F3 100%);
            color: white;
            padding: 12px 24px;
            border-radius: 24px;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            display: inline-block;
            transition: all 0.2s ease;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            box-shadow: 0 2px 4px rgba(33, 150, 243, 0.3);
        }

        .feature-card .btn:hover {
            background: linear-gradient(135deg, #1565C0 0%, #1976D2 100%);
            box-shadow: 0 4px 8px rgba(33, 150, 243, 0.4);
            transform: translateY(-2px);
        }

        /* Footer */
        footer {
            background: white;
            color: #616161;
            text-align: center;
            padding: 20px 16px;
            font-size: 12px;
            position: sticky;
            bottom: 0;
            z-index: 100;
            box-shadow: 0 -2px 4px rgba(0,0,0,0.1);
            border-top: 1px solid rgba(33, 150, 243, 0.1);
        }

        footer p {
            margin: 0;
        }

        /* Animations */
        @keyframes fadeInDown {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Mobile Responsive */
        @media (max-width: 768px) {
            .nav-menu-container {
                padding: 12px;
            }

            .nav-menu-grid {
                display: grid;
                grid-template-columns: repeat(3, 1fr);
                gap: 8px;
                width: 100%;
                max-width: 100%;
            }

            .nav-menu-item {
                padding: 12px 8px;
                min-width: 0;
                width: 100%;
                box-sizing: border-box;
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
                min-height: 90px;
            }

            .nav-menu-icon {
                width: 36px;
                height: 36px;
                margin: 0 auto;
            }

            .nav-menu-icon svg {
                width: 20px;
                height: 20px;
            }

            .nav-menu-label {
                font-size: 11px;
                text-align: center;
                white-space: normal;
                word-wrap: break-word;
                line-height: 1.2;
                margin-top: 4px;
            }

            .hero {
                padding: 24px 16px 20px;
                margin-bottom: 32px;
            }

            .hero::before {
                width: 60px;
                height: 3px;
            }

            .hero h2 {
                font-size: 24px;
                padding: 0 16px;
            }

            .hero h2::after {
                width: 50px;
                height: 2px;
            }

            .hero p {
                font-size: 13px;
                margin-top: 12px;
            }

            .features {
                grid-template-columns: 1fr;
                gap: 16px;
            }

            .feature-card {
                padding: 24px 20px;
            }
        }

        @media (max-width: 480px) {
            .app-title h1 {
                font-size: 18px;
            }

            .nav-menu-container {
                padding: 8px;
            }

            .nav-menu-grid {
                gap: 6px;
            }

            .nav-menu-item {
                padding: 10px 6px;
            }

            .nav-menu-icon {
                width: 32px;
                height: 32px;
            }

            .nav-menu-icon svg {
                width: 18px;
                height: 18px;
            }

            .nav-menu-label {
                font-size: 10px;
            }

            .hero {
                padding: 20px 12px 16px;
            }

            .hero::before {
                width: 50px;
                height: 2px;
            }

            .hero h2 {
                font-size: 20px;
                padding: 0 12px;
            }

            .hero h2::after {
                width: 40px;
                height: 2px;
            }

            .hero p {
                font-size: 12px;
            }

            footer {
                padding: 16px 12px;
                font-size: 11px;
            }

            main {
                padding-bottom: 60px;
            }
        }

        /* Smooth scroll */
        html {
            scroll-behavior: smooth;
        }
    </style>
</head>
<body>
    <!-- Android Style App Bar -->
    <div class="app-bar">
        <div class="app-bar-content">
            <div class="app-title">
                <svg class="app-icon" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                <h1>Halo Pemko Langsa</h1>
            </div>
        </div>
    </div>

    <!-- Android Style Navigation Menu -->
    <div class="nav-menu-container">
        <div class="nav-menu-grid">
            <a href="/halopemko/public/index.php" class="nav-menu-item active">
                <div class="nav-menu-icon">
                    <svg width="28" height="28" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3 9L12 2L21 9V20C21 20.5304 20.7893 21.0391 20.4142 21.4142C20.0391 21.7893 19.5304 22 19 22H5C4.46957 22 3.96086 21.7893 3.58579 21.4142C3.21071 21.0391 3 20.5304 3 20V9Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M9 22V12H15V22" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <span class="nav-menu-label">Beranda</span>
            </a>

            <a href="/halopemko/public/index.php?action=report" class="nav-menu-item">
                <div class="nav-menu-icon">
                    <svg width="28" height="28" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M14 2H6C5.46957 2 4.96086 2.21071 4.58579 2.58579C4.21071 2.96086 4 3.46957 4 4V20C4 20.5304 4.21071 21.0391 4.58579 21.4142C4.96086 21.7893 5.46957 22 6 22H18C18.5304 22 19.0391 21.7893 19.4142 21.4142C19.7893 21.0391 20 20.5304 20 20V8L14 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M14 2V8H20" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M12 18V12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M9 15H15" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <span class="nav-menu-label">Buat Pengaduan</span>
            </a>

            <a href="/halopemko/public/index.php?action=status" class="nav-menu-item">
                <div class="nav-menu-icon">
                    <svg width="28" height="28" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M9 12L11 14L15 10" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <span class="nav-menu-label">Cek Status</span>
            </a>
        </div>
    </div>

    <main>
        <section class="hero">
            <h2>Selamat Datang di Halo Pemko Kota Langsa</h2>
            <p>Layanan pengaduan masyarakat berbasis tiket untuk memudahkan komunikasi antara warga dan pemerintah kota.</p>
        </section>

        <section class="features">
            <div class="feature-card">
                <h3>Buat Pengaduan</h3>
                <p>Laporkan masalah atau keluhan Anda dengan mudah melalui form online.</p>
                <a href="/halopemko/public/index.php?action=report" class="btn">Buat Pengaduan</a>
            </div>

            <div class="feature-card">
                <h3>Cek Status</h3>
                <p>Pantau status pengaduan Anda dengan nomor tiket yang telah diberikan.</p>
                <a href="/halopemko/public/index.php?action=status" class="btn">Cek Status</a>
            </div>

            <div class="feature-card">
                <h3>Transparan</h3>
                <p>Semua pengaduan diproses secara transparan dan dapat dilacak statusnya.</p>
            </div>
        </section>
    </main>

    <footer>
        <p>&copy; <?php echo date('Y'); ?> Halo Pemko Kota Langsa. All rights reserved.</p>
    </footer>
</body>
</html>
