<?php
/**
 * Status Controller
 */

class StatusController {
    private $ticketModel;
    private $commentModel;

    public function __construct() {
        $this->ticketModel = new Ticket();
        $this->commentModel = new TicketComment();
    }

    public function showForm() {
        $ticket = null;
        $comments = [];

        if (isset($_GET['ticket_no']) && !empty($_GET['ticket_no'])) {
            $ticketNo = trim($_GET['ticket_no']);
            $ticket = $this->ticketModel->findByTicketNo($ticketNo);
            
            if ($ticket) {
                $comments = $this->commentModel->getByTicketId($ticket['id']);
            } else {
                $_SESSION['error'] = "Tiket tidak ditemukan";
            }
        }

        // Get WhatsApp number from settings
        $whatsappNumber = SettingsController::getWhatsAppNumber();

        require __DIR__ . '/../views/public/status.php';
    }
}

